// LittleMeshViewrView.h : interface of the CLittleMeshViewrView class
//


#pragma once


class CToolCameraManager;

class CLittleMeshViewrView : public CView
{
protected: // create from serialization only
	CLittleMeshViewrView();
	DECLARE_DYNCREATE(CLittleMeshViewrView)

// Attributes
public:
	CLittleMeshViewrDoc* GetDocument() const;

	void CreateSceneOnce();
	void InitGrid();
	void InitUtilities();

// Operations
public:
	bool					m_bSetupOgre;
	bool					m_bMouseMiddleButtonFlag;
	bool					m_bLeftAltKeyFlag;
	CToolCameraManager*		m_pCameraUtil;

	CPoint					m_PrevMousePoint;

// Overrides
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:

// Implementation
public:
	virtual ~CLittleMeshViewrView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
};

#ifndef _DEBUG  // debug version in LittleMeshViewrView.cpp
inline CLittleMeshViewrDoc* CLittleMeshViewrView::GetDocument() const
   { return reinterpret_cast<CLittleMeshViewrDoc*>(m_pDocument); }
#endif

