// LittleMeshViewrView.cpp : implementation of the CLittleMeshViewrView class
//

#include "stdafx.h"
#include "LittleMeshViewr.h"

#include "LittleMeshViewrDoc.h"
#include "LittleMeshViewrView.h"

#include "ToolCameraManager.h"

//#ifdef _DEBUG
//#define new DEBUG_NEW
//#endif


// CLittleMeshViewrView

IMPLEMENT_DYNCREATE(CLittleMeshViewrView, CView)

BEGIN_MESSAGE_MAP(CLittleMeshViewrView, CView)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_MOUSEWHEEL()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_SYSKEYDOWN()
	ON_WM_SYSKEYUP()
END_MESSAGE_MAP()

// CLittleMeshViewrView construction/destruction

CLittleMeshViewrView::CLittleMeshViewrView()
{
	// TODO: add construction code here
	m_bSetupOgre = false;

	m_pCameraUtil = NULL;
	m_bMouseMiddleButtonFlag = false;
	m_bLeftAltKeyFlag = false;
	m_PrevMousePoint.x = 0;
	m_PrevMousePoint.y = 0;
}

CLittleMeshViewrView::~CLittleMeshViewrView()
{
	if(m_pCameraUtil)
	{
		delete m_pCameraUtil;
		m_pCameraUtil = NULL;
	}
}

BOOL CLittleMeshViewrView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

// CLittleMeshViewrView drawing

void CLittleMeshViewrView::OnDraw(CDC* /*pDC*/)
{
	CLittleMeshViewrDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	if(false == m_bSetupOgre)
	{
		// OnDraw ʷ ȣɶ ѹ ִ ʱȭ ڵ̴.
		CreateSceneOnce();
	}

	theApp.m_pOgreRoot->renderOneFrame();
}


// CLittleMeshViewrView diagnostics

#ifdef _DEBUG
void CLittleMeshViewrView::AssertValid() const
{
	CView::AssertValid();
}

void CLittleMeshViewrView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CLittleMeshViewrDoc* CLittleMeshViewrView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLittleMeshViewrDoc)));
	return (CLittleMeshViewrDoc*)m_pDocument;
}
#endif //_DEBUG


// CLittleMeshViewrView message handlers

BOOL CLittleMeshViewrView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default
	return TRUE;
	//return CView::OnEraseBkgnd(pDC);
}

void CLittleMeshViewrView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
	if(m_bSetupOgre && theApp.m_pRenderWindow)
	{
		theApp.m_pRenderWindow->windowMovedOrResized();
		// Adjust camera's aspect ratio, too 
		CRect rect;
		GetClientRect(&rect);
		if((rect.Height() != 0) && (theApp.m_pCamera != 0))
		{
			theApp.m_pCamera->setAspectRatio(
				(Ogre::Real)theApp.m_pRenderWindow->getWidth() / (Ogre::Real)theApp.m_pRenderWindow->getHeight());
		}
		theApp.m_pCamera->yaw(Radian(0));
	}
}

void CLittleMeshViewrView::CreateSceneOnce()
{
	m_bSetupOgre = true;
	RECT rect;
	GetClientRect(&rect);
	theApp.SetupOgre(m_hWnd, rect.right-rect.left, rect.bottom-rect.top);

	InitGrid();
	InitUtilities();
}

void CLittleMeshViewrView::InitGrid()
{
	ManualObject* myManualObject =  theApp.m_pSceneManager->createManualObject("manual1"); 
	SceneNode* myManualObjectNode = theApp.m_pSceneManager->getRootSceneNode()->createChildSceneNode("manual1_node"); 

	MaterialPtr myManualObjectMaterial = MaterialManager::getSingleton().create("manual1Material","debugger"); 
	myManualObjectMaterial->setReceiveShadows(false); 
	myManualObjectMaterial->getTechnique(0)->setLightingEnabled(true); 
	myManualObjectMaterial->getTechnique(0)->getPass(0)->setDiffuse(1,1,1,0); 
	myManualObjectMaterial->getTechnique(0)->getPass(0)->setAmbient(1,1,1); 
	myManualObjectMaterial->getTechnique(0)->getPass(0)->setSelfIllumination(1,1,1); 

	myManualObject->begin("manual1Material", Ogre::RenderOperation::OT_LINE_LIST); 
	for(int i=0; i<21; i++)
	{
		myManualObject->position(-10, 0, 10-i);
		myManualObject->position(10, 0, 10-i);

		myManualObject->position(-10+i, 0, 10);
		myManualObject->position(-10+i, 0, -10);
	}

	myManualObject->position(0, 10, 0);
	myManualObject->position(0, -10, 0);
	myManualObject->end(); 

	myManualObjectNode->attachObject(myManualObject);
}

void CLittleMeshViewrView::InitUtilities()
{
	m_pCameraUtil = new CToolCameraManager();
}

BOOL CLittleMeshViewrView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: Add your message handler code here and/or call default

	bool bZoomIn = true;
	if(zDelta <= 0)
	{
		bZoomIn = false;
	}
	m_pCameraUtil->ZoomCamera(bZoomIn);
	Invalidate();

	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CLittleMeshViewrView::OnMButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	m_bMouseMiddleButtonFlag = true;
	CView::OnMButtonDown(nFlags, point);
}

void CLittleMeshViewrView::OnMButtonUp(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	m_bMouseMiddleButtonFlag = false;
	CView::OnMButtonUp(nFlags, point);
}

void CLittleMeshViewrView::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	if(m_bMouseMiddleButtonFlag)
	{
		int xDelta = point.x - m_PrevMousePoint.x;
		int yDelta = point.y - m_PrevMousePoint.y;

		if(m_bLeftAltKeyFlag)
		{
			m_pCameraUtil->RotationCamera(yDelta,xDelta);
		}
		else
		{
			m_pCameraUtil->MoveCamera(xDelta,yDelta);
		}
		Invalidate();
	}

	m_PrevMousePoint = point;
	CView::OnMouseMove(nFlags, point);
}

void CLittleMeshViewrView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	if(('C' == nChar) || ('c' == nChar))
	{
		m_pCameraUtil->ResetCameraPositionOrientation();
		Invalidate();
	}

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CLittleMeshViewrView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CLittleMeshViewrView::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	m_bLeftAltKeyFlag = true;
	CView::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

void CLittleMeshViewrView::OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	m_bLeftAltKeyFlag = false;
	CView::OnSysKeyUp(nChar, nRepCnt, nFlags);
}
