// LittleMeshViewrDoc.h : interface of the CLittleMeshViewrDoc class
//


#pragma once

class CToolMeshManager;
class CToolAnimationManager;
class CAnimationControlDlg;

class CLittleMeshViewrDoc : public CDocument
{
protected: // create from serialization only
	CLittleMeshViewrDoc();
	DECLARE_DYNCREATE(CLittleMeshViewrDoc)

private:
	CToolMeshManager*			m_pMeshUtil;
	CToolAnimationManager*		m_pAnimationUtil;
	CAnimationControlDlg*		m_pAnimationControlDlg;

public:
	// about mesh
	void	LoadMesh(const char* szFileName);
	void	AddMesh(const char* szFileName);
	bool	IsMainMeshLoaded();

	// about animation
	void	SelectAnimation(const char* szAnimationName);
	void	PlayAnimation();
	void	PauseAnimation();
	void	StopAnimation();
	void	ChangeAnimationSpeedFactor(float fFactor);
	void	SetAnimationTimePosition(float fTimePosition);
	void	AddSkeletonFile(const char* szSkeletonFile);

	// loop
	void	FrameProc(DWORD dwTimeSinceLastFrame);

// Attributes
public:

// Operations
public:

// Overrides
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CLittleMeshViewrDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
};


