package com.ibatis.jpetstore.presentation.action;

import com.ibatis.common.util.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class ViewCategoryAction extends BaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    String categoryId = request.getParameter("categoryId");

    PaginatedList productList = (PaginatedList) request.getSession().getAttribute("productList");

    if (categoryId != null) {
      request.getSession().setAttribute("productList", petStore.getProductListByCategory(categoryId));
      request.getSession().setAttribute("category", petStore.getCategory(categoryId));
    } else if (productList != null) {
      String page = request.getParameter("page");
      if ("next".equals(page)) {
        productList.nextPage();
      } else if ("previous".equals(page)) {
        productList.previousPage();
      }
    }

    return mapping.findForward("success");
  }

}
