package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class RemoveItemFromCartAction extends BaseAction {


  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    CartForm cartForm = (CartForm) form;

    Item item = cartForm.getCart().removeItemById(cartForm.getWorkingItemId());

    if (item == null) {
      request.setAttribute("message", "Attempted to remove null CartItem from Cart.");
      return mapping.findForward("failure");
    } else {
      return mapping.findForward("success");
    }
  }

}
