/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.CodeGeneratorBackend;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class ASMBackend
extends CodeGeneratorBackend
implements Constants {
    private ClassWriter cw;
    private CodeVisitor cv;
    private boolean interfaceFlag;
    private Set interfaces = new HashSet();
    private Map labels = new HashMap();

    public ASMBackend(String className, Class superclass) {
        super(className, superclass);
    }

    private boolean inited() {
        return this.cw != null;
    }

    private void init() {
        if (this.cw == null) {
            this.cw = new ClassWriter(true);
            String[] interfaceNames = null;
            if (this.interfaces.size() > 0) {
                interfaceNames = this.getInternalNames(this.interfaces.toArray(new Class[this.interfaces.size()]));
            }
            this.cw.visit(1 | (this.interfaceFlag ? 512 : 0), this.getInternalName(this.className), Type.getInternalName((Class)this.superclass), interfaceNames, "<generated>");
        }
    }

    public void setInterface(boolean flag) {
        if (this.inited()) {
            throw new RuntimeException("Cannot set interface status after ClassWriter has been initialized");
        }
        this.interfaceFlag = flag;
    }

    public byte[] getBytes() {
        this.cw.visitEnd();
        return this.cw.toByteArray();
    }

    private Label make_label(Object maybeLabel) {
        if (maybeLabel instanceof Label) {
            return (Label)maybeLabel;
        }
        Label label = (Label)this.labels.get(maybeLabel);
        if (label == null) {
            label = (Label)this.make_label();
            this.labels.put(maybeLabel, label);
        }
        return label;
    }

    public Object make_label() {
        return new Label();
    }

    public void ifeq(Object label) {
        this.cv.visitJumpInsn(153, this.make_label(label));
    }

    public void ifne(Object label) {
        this.cv.visitJumpInsn(154, this.make_label(label));
    }

    public void iflt(Object label) {
        this.cv.visitJumpInsn(155, this.make_label(label));
    }

    public void ifge(Object label) {
        this.cv.visitJumpInsn(156, this.make_label(label));
    }

    public void ifgt(Object label) {
        this.cv.visitJumpInsn(157, this.make_label(label));
    }

    public void ifle(Object label) {
        this.cv.visitJumpInsn(158, this.make_label(label));
    }

    public void goTo(Object label) {
        this.cv.visitJumpInsn(167, this.make_label(label));
    }

    public void ifnull(Object label) {
        this.cv.visitJumpInsn(198, this.make_label(label));
    }

    public void ifnonnull(Object label) {
        this.cv.visitJumpInsn(199, this.make_label(label));
    }

    public void if_icmplt(Object label) {
        this.cv.visitJumpInsn(161, this.make_label(label));
    }

    public void if_icmpne(Object label) {
        this.cv.visitJumpInsn(160, this.make_label(label));
    }

    public void if_icmpeq(Object label) {
        this.cv.visitJumpInsn(159, this.make_label(label));
    }

    public void nop(Object label) {
        this.cv.visitLabel(this.make_label(label));
        this.cv.visitInsn(0);
    }

    public void imul() {
        this.cv.visitInsn(104);
    }

    public void iadd() {
        this.cv.visitInsn(96);
    }

    public void lushr() {
        this.cv.visitInsn(125);
    }

    public void lxor() {
        this.cv.visitInsn(131);
    }

    public void ixor() {
        this.cv.visitInsn(130);
    }

    public void l2i() {
        this.cv.visitInsn(136);
    }

    public void dcmpg() {
        this.cv.visitInsn(152);
    }

    public void fcmpg() {
        this.cv.visitInsn(150);
    }

    public void lcmp() {
        this.cv.visitInsn(148);
    }

    public void aconst_null() {
        this.cv.visitInsn(1);
    }

    public void arraylength() {
        this.cv.visitInsn(190);
    }

    public void newarray(Class clazz) {
        int v = 0;
        switch (clazz.getName().charAt(0)) {
            case 'B': {
                v = 8;
                break;
            }
            case 'C': {
                v = 5;
                break;
            }
            case 'D': {
                v = 7;
                break;
            }
            case 'F': {
                v = 6;
                break;
            }
            case 'I': {
                v = 10;
                break;
            }
            case 'J': {
                v = 11;
                break;
            }
            case 'S': {
                v = 9;
                break;
            }
            case 'Z': {
                v = 4;
            }
        }
        this.cv.visitIntInsn(188, v);
    }

    public void anewarray(Class clazz) {
        String desc = clazz.isArray() ? Type.getDescriptor((Class)clazz) : Type.getInternalName((Class)clazz);
        this.cv.visitTypeInsn(189, desc);
    }

    public void new_instance(String className) {
        this.cv.visitTypeInsn(187, this.getInternalName(className));
    }

    public void checkcast(String className) {
        this.cv.visitTypeInsn(192, this.getInternalName(className));
    }

    public void instance_of(String className) {
        this.cv.visitTypeInsn(193, this.getInternalName(className));
    }

    public void aaload() {
        this.cv.visitInsn(50);
    }

    public void aastore() {
        this.cv.visitInsn(83);
    }

    public void athrow() {
        this.cv.visitInsn(191);
    }

    private String getInternalName(String className) {
        return className == null ? null : className.replace('.', '/');
    }

    private String[] getInternalNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] copy = new String[classes.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = Type.getInternalName((Class)classes[i]);
            ++i;
        }
        return copy;
    }

    public void pop() {
        this.cv.visitInsn(87);
    }

    public void pop2() {
        this.cv.visitInsn(88);
    }

    public void dup() {
        this.cv.visitInsn(89);
    }

    public void dup2() {
        this.cv.visitInsn(92);
    }

    public void dup_x1() {
        this.cv.visitInsn(90);
    }

    public void dup_x2() {
        this.cv.visitInsn(91);
    }

    public void swap() {
        this.cv.visitInsn(95);
    }

    public void invoke_interface(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.methodHelper(185, className, methodName, returnType, parameterTypes);
    }

    public void invoke_virtual(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.methodHelper(182, className, methodName, returnType, parameterTypes);
    }

    public void invoke_static(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.methodHelper(184, className, methodName, returnType, parameterTypes);
    }

    public void invoke_special(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.methodHelper(183, className, methodName, returnType, parameterTypes);
    }

    private void methodHelper(int opcode, String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.cv.visitMethodInsn(opcode, this.getInternalName(className), methodName, Type.getMethodDescriptor((Type)Type.getType((Class)returnType), (Type[])this.getTypes(parameterTypes)));
    }

    public void declare_field(int modifiers, Class typeClass, String fieldName) {
        this.init();
        this.cw.visitField(ASMBackend.convertModifiers(modifiers), fieldName, Type.getDescriptor((Class)typeClass), null);
    }

    public void getfield(String className, String fieldName, Class type) {
        this.fieldHelper(180, className, fieldName, type);
    }

    public void putfield(String className, String fieldName, Class type) {
        this.fieldHelper(181, className, fieldName, type);
    }

    public void getstatic(String className, String fieldName, Class type) {
        this.fieldHelper(178, className, fieldName, type);
    }

    public void putstatic(String className, String fieldName, Class type) {
        this.fieldHelper(179, className, fieldName, type);
    }

    private void fieldHelper(int opcode, String className, String fieldName, Class type) {
        this.cv.visitFieldInsn(opcode, this.getInternalName(className), fieldName, Type.getDescriptor((Class)type));
    }

    public void begin_static() {
        this.init();
        this.cv = this.cw.visitMethod(8, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null);
    }

    public void declare_interface(Class iface) {
        if (this.inited()) {
            throw new RuntimeException("Cannot declare interface after ClassWriter has been initialized");
        }
        this.interfaces.add(iface);
    }

    public void begin_method(int modifiers, Class returnType, String methodName, Class[] parameterTypes, Class[] exceptionTypes) {
        this.init();
        this.labels.clear();
        this.cv = this.cw.visitMethod(ASMBackend.convertModifiers(modifiers), methodName, Type.getMethodDescriptor((Type)Type.getType((Class)returnType), (Type[])this.getTypes(parameterTypes)), this.getInternalNames(exceptionTypes));
    }

    private Label mark() {
        Object label = this.make_label();
        this.nop(label);
        return (Label)label;
    }

    public Object start_range() {
        return this.mark();
    }

    public Object end_range() {
        return this.mark();
    }

    public void handle_exception(Object start, Object end, Class exceptionType) {
        this.cv.visitTryCatchBlock(this.make_label(start), this.make_label(end), this.mark(), Type.getInternalName((Class)exceptionType));
    }

    public void begin_constructor(Class[] parameterTypes) {
        this.init();
        this.cv = this.cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])this.getTypes(parameterTypes)), null);
    }

    public void end_method() {
        this.cv.visitMaxs(0, 0);
    }

    public void ldc(String value) {
        this.cv.visitLdcInsn((Object)value);
    }

    public void ldc(double value) {
        this.cv.visitLdcInsn((Object)new Double(value));
    }

    public void ldc(long value) {
        this.cv.visitLdcInsn((Object)new Long(value));
    }

    public void ldc(int value) {
        this.cv.visitLdcInsn((Object)new Integer(value));
    }

    public void ldc(float value) {
        this.cv.visitLdcInsn((Object)new Float(value));
    }

    public void laload() {
        this.cv.visitInsn(47);
    }

    public void daload() {
        this.cv.visitInsn(49);
    }

    public void faload() {
        this.cv.visitInsn(48);
    }

    public void saload() {
        this.cv.visitInsn(53);
    }

    public void caload() {
        this.cv.visitInsn(52);
    }

    public void iaload() {
        this.cv.visitInsn(46);
    }

    public void baload() {
        this.cv.visitInsn(51);
    }

    public void lastore() {
        this.cv.visitInsn(80);
    }

    public void dastore() {
        this.cv.visitInsn(82);
    }

    public void fastore() {
        this.cv.visitInsn(81);
    }

    public void sastore() {
        this.cv.visitInsn(86);
    }

    public void castore() {
        this.cv.visitInsn(85);
    }

    public void iastore() {
        this.cv.visitInsn(79);
    }

    public void bastore() {
        this.cv.visitInsn(84);
    }

    public void iconst(int value) {
        switch (value) {
            case -1: {
                this.cv.visitInsn(2);
                break;
            }
            case 0: {
                this.cv.visitInsn(3);
                break;
            }
            case 1: {
                this.cv.visitInsn(4);
                break;
            }
            case 2: {
                this.cv.visitInsn(5);
                break;
            }
            case 3: {
                this.cv.visitInsn(6);
                break;
            }
            case 4: {
                this.cv.visitInsn(7);
                break;
            }
            case 5: {
                this.cv.visitInsn(8);
            }
        }
    }

    public void bipush(byte value) {
        this.cv.visitIntInsn(16, (int)value);
    }

    public void sipush(short value) {
        this.cv.visitIntInsn(17, (int)value);
    }

    public void lconst(long value) {
        this.cv.visitInsn(value == 0L ? 9 : 10);
    }

    public void fconst(float value) {
        if (value == 0.0f) {
            this.cv.visitInsn(11);
        } else if (value == 1.0f) {
            this.cv.visitInsn(12);
        } else {
            this.cv.visitInsn(13);
        }
    }

    public void dconst(double value) {
        this.cv.visitInsn(value == 0.0 ? 14 : 15);
    }

    public void lload(int index) {
        this.cv.visitVarInsn(22, index);
    }

    public void dload(int index) {
        this.cv.visitVarInsn(24, index);
    }

    public void fload(int index) {
        this.cv.visitVarInsn(23, index);
    }

    public void iload(int index) {
        this.cv.visitVarInsn(21, index);
    }

    public void aload(int index) {
        this.cv.visitVarInsn(25, index);
    }

    public void lstore(int index) {
        this.cv.visitVarInsn(55, index);
    }

    public void dstore(int index) {
        this.cv.visitVarInsn(57, index);
    }

    public void fstore(int index) {
        this.cv.visitVarInsn(56, index);
    }

    public void istore(int index) {
        this.cv.visitVarInsn(54, index);
    }

    public void astore(int index) {
        this.cv.visitVarInsn(58, index);
    }

    public void returnVoid() {
        this.cv.visitInsn(177);
    }

    public void lreturn() {
        this.cv.visitInsn(173);
    }

    public void dreturn() {
        this.cv.visitInsn(175);
    }

    public void freturn() {
        this.cv.visitInsn(174);
    }

    public void ireturn() {
        this.cv.visitInsn(172);
    }

    public void areturn() {
        this.cv.visitInsn(176);
    }

    public void iinc(int index, int amount) {
        this.cv.visitIincInsn(index, amount);
    }

    private static int convertModifiers(int modifiers) {
        int result = 0;
        if (Modifier.isAbstract(modifiers)) {
            result |= 0x400;
        }
        if (Modifier.isFinal(modifiers)) {
            result |= 0x10;
        }
        if (Modifier.isInterface(modifiers)) {
            result |= 0x200;
        }
        if (Modifier.isNative(modifiers)) {
            result |= 0x100;
        }
        if (Modifier.isPrivate(modifiers)) {
            result |= 2;
        }
        if (Modifier.isProtected(modifiers)) {
            result |= 4;
        }
        if (Modifier.isPublic(modifiers)) {
            result |= 1;
        }
        if (Modifier.isStatic(modifiers)) {
            result |= 8;
        }
        if (Modifier.isStrict(modifiers)) {
            result |= 0x800;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result |= 0x20;
        }
        if (Modifier.isTransient(modifiers)) {
            result |= 0x80;
        }
        if (Modifier.isVolatile(modifiers)) {
            result |= 0x40;
        }
        return result;
    }

    private Type[] getTypes(Class[] classes) {
        Type[] types = new Type[classes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = Type.getType((Class)classes[i]);
            ++i;
        }
        return types;
    }
}

