/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao.jdbc;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import com.ibatis.db.dao.jdbc.SqlMapDaoTransaction;
import com.ibatis.db.sqlmap.SqlMap;
import com.ibatis.db.sqlmap.XmlSqlMapBuilder;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;

public class SqlMapDaoTransactionPool
implements DaoTransactionPool {
    private SqlMap sqlMap;

    public void configure(Map map) throws DaoException {
        try {
            String string = (String)map.get("sql-map-config-file");
            Reader reader = Resources.getResourceAsReader(string);
            this.sqlMap = XmlSqlMapBuilder.buildSqlMap(reader);
        }
        catch (Exception exception) {
            throw new NestedRuntimeException("Error configuring SqlMapDaoTransactionPool.  Cause: " + exception, exception);
        }
    }

    public DaoTransaction getTransaction() throws DaoException {
        try {
            this.sqlMap.startTransaction();
            return new SqlMapDaoTransaction(this.sqlMap);
        }
        catch (SQLException sQLException) {
            throw new DaoException("Error getting transaction. Cause: " + sQLException, sQLException);
        }
    }

    public void releaseTransaction(DaoTransaction daoTransaction) throws DaoException {
    }

    public SqlMap getSqlMap() {
        return this.sqlMap;
    }
}

