/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.flatfile;

import com.ibatis.common.flatfile.FlatFileOut;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class DelimitedFlatFileOut
implements FlatFileOut {
    private static final int UNKNOWN_COLUM_COUNT = -1;
    private Writer writer = null;
    private ArrayList values = new ArrayList();
    private String delimiter = " ";
    private int colCount = -1;

    public DelimitedFlatFileOut(String string, String string2) throws IOException {
        this.delimiter = string2;
        this.writer = new BufferedWriter(new FileWriter(string));
    }

    public void nextRecord() throws IOException {
        if (this.colCount == -1) {
            this.colCount = this.values.size();
        } else if (this.colCount != this.values.size()) {
            throw new IOException("Inconsistent number of columns in row.");
        }
        int n = 0;
        while (n < this.values.size()) {
            if (this.values.get(n) == null) {
                this.writer.write("");
            } else {
                this.writer.write((String)this.values.get(n));
            }
            if (n + 1 < this.values.size()) {
                this.writer.write(this.delimiter);
            }
            ++n;
        }
        this.writer.write("\r\n");
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public int getColumnCount() throws IOException {
        return this.colCount;
    }

    public void setValueAt(int n, String string) throws IOException {
        while (n + 1 > this.values.size()) {
            this.values.add("");
        }
        this.values.set(n, string);
    }
}

